/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <fcntl.h>

#if (WIN32|WINNT)
#include <io.h>
#endif


#include "udm_common.h"
#include "udm_proto.h"
#include "udm_utils.h"
#include "udm_vars.h"

int   UdmMirrorGET(UDM_AGENT * Indexer,UDM_DOCUMENT *Doc,UDM_URL *url,char *errstr) {
	int		size = 0;
	int		fbody, fheader;
	char		str[1024]="";
	struct stat	sb;
	time_t		nowtime;
	int		have_headers=0;
	int		mirror_period=UdmVarListFindInt(&Doc->Sections,"MirrorPeriod",-1);
	const char	*mirror_data=UdmVarListFindStr(&Doc->Sections,"MirrorRoot",NULL);
	const char	*mirror_hdrs=UdmVarListFindStr(&Doc->Sections,"MirrorHeadersRoot",NULL);
	
	Doc->Buf.size=0;
	nowtime = time(NULL);
	
	if(mirror_period <= 0)return(UDM_MIRROR_NOT_FOUND);
	
	/* MirrorRoot is not specified, nothing to do */
	if(mirror_data)return(UDM_MIRROR_NOT_FOUND);
	
	snprintf(str,sizeof(str)-1,"%s/%s/%s/%s/%s",
		mirror_data,url->schema,url->hostname,url->path,
		url->filename && strlen(url->filename) ? 
			url->filename : "index.html");

	if ((fbody = open(str, O_RDONLY|UDM_BINARY)) == -1){
		sprintf(errstr,"Mirror file %s not found", str);
		return UDM_MIRROR_NOT_FOUND;
	}

	/* Check on file mtime > days ? return */
	if (fstat(fbody, &sb)) {
		return UDM_MIRROR_NOT_FOUND;
	}
	if (nowtime > sb.st_mtime + mirror_period ) {
		close(fbody);
		sprintf(errstr,"%s is older then %d secs", str, mirror_period);
		return UDM_MIRROR_EXPIRED;
	}

	if(mirror_hdrs){
		snprintf(str,sizeof(str)-1,"%s/%s/%s/%s/%s.hreader",
			mirror_hdrs,url->schema,url->hostname,url->path,
			url->filename && strlen(url->filename) ?
				url->filename : "index.html");

		if ((fheader = open(str, O_RDONLY|UDM_BINARY))>=0) {
			size = read(fheader, Doc->Buf.buf, Doc->Buf.maxsize);
			close(fheader);
			strcpy(Doc->Buf.buf + size, "\r\n\r\n");
			have_headers=1;
		}
	}
	if(!have_headers){
		/* header file not found   */
		/* get body as file method */

		sprintf(Doc->Buf.buf,"HTTP/1.0 200 OK\r\n");
		sprintf(UDM_STREND(Doc->Buf.buf),"\r\n");
	}

	Doc->Buf.content = UDM_STREND(Doc->Buf.buf);
	size = read(fbody, Doc->Buf.content, Doc->Buf.maxsize - (Doc->Buf.content-Doc->Buf.buf));
	close(fbody);
	if(size<0)return size;
	/* Calculate size and append trailing 0 */
	Doc->Buf.size=(Doc->Buf.content-Doc->Buf.buf)+size;
	Doc->Buf.content[Doc->Buf.size]='\0';
	return 0;
}

int   UdmMirrorPUT(UDM_AGENT * Indexer,UDM_DOCUMENT *Doc, UDM_URL *url,char *errstr) {
	int		fd,size;
	char		str[1024]="";
	const char	*mirror_data=UdmVarListFindStr(&Doc->Sections,"MirrorRoot",NULL);
	const char	*mirror_hdrs=UdmVarListFindStr(&Doc->Sections,"MirrorHeadersRoot",NULL);
	
	/* Put Content if MirrorRoot is specified */
	if(mirror_data){
		snprintf(str,sizeof(str)-1,"%s/%s/%s/%s",
			mirror_data,url->schema,url->hostname,url->path);

#if (WIN32|WINNT)
		/* Replace slashes to Win style */
		{char *p; p=str;while(*p){if(*p=='/')*p='\\'; p++;}}
#endif
		if(UdmBuild(str, 0755) != 0){
			sprintf(errstr, "Can't create dir %s", str);
			return UDM_MIRROR_CANT_BUILD;
		}

		strcat(str,UDMSLASHSTR);
		strcat(str, url->filename && strlen(url->filename) 
			? url->filename : "index.html");
			
		if ((fd = open(str, O_CREAT|O_WRONLY|UDM_BINARY,UDM_IWRITE)) == -1){
			sprintf(errstr,"Can't open mirror file %s\n", str);
			return UDM_MIRROR_CANT_OPEN;
		}
		size = write(fd, Doc->Buf.content, Doc->Buf.size - (Doc->Buf.content-Doc->Buf.buf));
		close(fd);
	}

	/* Put Headers if MirrorHeadersRoot is specified */
	if(mirror_hdrs){
		snprintf(str,sizeof(str)-1,"%s/%s/%s/%s",
			mirror_hdrs,url->schema,url->hostname,url->path);

#if (WIN32|WINNT)
		/* Replace slashes to Win style */
		{char *p; p=str;while(*p){if(*p=='/')*p='\\'; p++;}}
#endif
		if(UdmBuild(str, 0755) != 0){
			sprintf(errstr, "Can't create mirror dir %s", str);
			return UDM_MIRROR_CANT_BUILD;
		}

		strcat(str,UDMSLASHSTR);
		strcat(str, url->filename && strlen(url->filename) ?
			url->filename : "index.html");
			
		strcat(str,".header");

		if ((fd = open(str, O_CREAT|O_WRONLY|UDM_BINARY,UDM_IWRITE)) == -1){
			sprintf(errstr,"Can't open mirror file %s\n", str);
			return UDM_MIRROR_CANT_OPEN;
		}
		size = write(fd, Doc->Buf.buf, strlen(Doc->Buf.buf));
		close(fd);
	}
	return(0);
}
